/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.command.defaults;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.defaults.VanillaCommand;
import org.bukkit.entity.Player;
import org.bukkit.util.StringUtil;

@Deprecated
public class ClearCommand
extends VanillaCommand {
    private static List<String> materials;

    static {
        ArrayList<String> materialList = new ArrayList<String>();
        Material[] materialArray = Material.values();
        int n = materialArray.length;
        int n2 = 0;
        while (n2 < n) {
            Material material = materialArray[n2];
            materialList.add(material.name());
            ++n2;
        }
        Collections.sort(materialList);
        materials = ImmutableList.copyOf(materialList);
    }

    public ClearCommand() {
        super("clear");
        this.description = "Clears the player's inventory. Can specify item and data filters too.";
        this.usageMessage = "/clear <player> [item] [data]";
        this.setPermission("bukkit.command.clear");
    }

    @Override
    public boolean execute(CommandSender sender, String currentAlias, String[] args) {
        if (!this.testPermission(sender)) {
            return true;
        }
        Player player = null;
        if (args.length > 0) {
            player = Bukkit.getPlayer(args[0]);
        } else if (sender instanceof Player) {
            player = (Player)sender;
        }
        if (player != null) {
            int id;
            if (args.length > 1 && !args[1].equals("-1")) {
                Material material = Material.matchMaterial(args[1]);
                if (material == null) {
                    sender.sendMessage((Object)((Object)ChatColor.RED) + "There's no item called " + args[1]);
                    return false;
                }
                id = material.getId();
            } else {
                id = -1;
            }
            int data = args.length >= 3 ? this.getInteger(sender, args[2], 0) : -1;
            int count = player.getInventory().clear(id, data);
            Command.broadcastCommandMessage(sender, "Cleared the inventory of " + player.getDisplayName() + ", removing " + count + " items");
        } else if (args.length == 0) {
            sender.sendMessage((Object)((Object)ChatColor.RED) + "Please provide a player!");
        } else {
            sender.sendMessage((Object)((Object)ChatColor.RED) + "Can't find player " + args[0]);
        }
        return true;
    }

    @Override
    public List<String> tabComplete(CommandSender sender, String alias, String[] args) throws IllegalArgumentException {
        Validate.notNull(sender, "Sender cannot be null");
        Validate.notNull(args, "Arguments cannot be null");
        Validate.notNull(alias, "Alias cannot be null");
        if (args.length == 1) {
            return super.tabComplete(sender, alias, args);
        }
        if (args.length == 2) {
            String arg = args[1];
            List<String> materials = ClearCommand.materials;
            ArrayList<String> completion = null;
            int size = materials.size();
            int i = Collections.binarySearch(materials, arg, String.CASE_INSENSITIVE_ORDER);
            if (i < 0) {
                i = -1 - i;
            }
            while (i < size) {
                String material = materials.get(i);
                if (!StringUtil.startsWithIgnoreCase(material, arg)) break;
                if (completion == null) {
                    completion = new ArrayList<String>();
                }
                completion.add(material);
                ++i;
            }
            if (completion != null) {
                return completion;
            }
        }
        return ImmutableList.of();
    }
}

