/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.plugin;

import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.Validate;
import org.bukkit.Server;
import org.bukkit.command.Command;
import org.bukkit.command.PluginCommandYamlParser;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.command.defaults.TimingsCommand;
import org.bukkit.event.Event;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.permissions.Permissible;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.AuthorNagException;
import org.bukkit.plugin.EventExecutor;
import org.bukkit.plugin.IllegalPluginAccessException;
import org.bukkit.plugin.InvalidDescriptionException;
import org.bukkit.plugin.InvalidPluginException;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.PluginLoader;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.RegisteredListener;
import org.bukkit.plugin.TimedRegisteredListener;
import org.bukkit.plugin.UnknownDependencyException;
import org.bukkit.util.FileUtil;

public final class SimplePluginManager
implements PluginManager {
    private final Server server;
    private final Map<Pattern, PluginLoader> fileAssociations = new HashMap<Pattern, PluginLoader>();
    private final List<Plugin> plugins = new ArrayList<Plugin>();
    private final Map<String, Plugin> lookupNames = new HashMap<String, Plugin>();
    private static File updateDirectory = null;
    private final SimpleCommandMap commandMap;
    private final Map<String, Permission> permissions = new HashMap<String, Permission>();
    private final Map<Boolean, Set<Permission>> defaultPerms = new LinkedHashMap<Boolean, Set<Permission>>();
    private final Map<String, Map<Permissible, Boolean>> permSubs = new HashMap<String, Map<Permissible, Boolean>>();
    private final Map<Boolean, Map<Permissible, Boolean>> defSubs = new HashMap<Boolean, Map<Permissible, Boolean>>();
    private boolean useTimings = false;

    public SimplePluginManager(Server instance, SimpleCommandMap commandMap) {
        this.server = instance;
        this.commandMap = commandMap;
        this.defaultPerms.put(true, new HashSet());
        this.defaultPerms.put(false, new HashSet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerInterface(Class<? extends PluginLoader> loader) throws IllegalArgumentException {
        PluginLoader instance;
        if (PluginLoader.class.isAssignableFrom(loader)) {
            try {
                Constructor<? extends PluginLoader> constructor = loader.getConstructor(Server.class);
                instance = constructor.newInstance(this.server);
            }
            catch (NoSuchMethodException ex) {
                String className = loader.getName();
                throw new IllegalArgumentException(String.format("Class %s does not have a public %s(Server) constructor", className, className), ex);
            }
            catch (Exception ex) {
                throw new IllegalArgumentException(String.format("Unexpected exception %s while attempting to construct a new instance of %s", ex.getClass().getName(), loader.getName()), ex);
            }
        } else {
            throw new IllegalArgumentException(String.format("Class %s does not implement interface PluginLoader", loader.getName()));
        }
        Pattern[] patterns = instance.getPluginFileFilters();
        SimplePluginManager simplePluginManager = this;
        synchronized (simplePluginManager) {
            Pattern[] patternArray = patterns;
            int n = patterns.length;
            int n2 = 0;
            while (n2 < n) {
                Pattern pattern = patternArray[n2];
                this.fileAssociations.put(pattern, instance);
                ++n2;
            }
        }
    }

    @Override
    public Plugin[] loadPlugins(File directory) {
        Validate.notNull(directory, "Directory cannot be null");
        Validate.isTrue(directory.isDirectory(), "Directory must be a directory");
        ArrayList<Plugin> result = new ArrayList<Plugin>();
        Set<Pattern> filters = this.fileAssociations.keySet();
        if (!this.server.getUpdateFolder().equals("")) {
            updateDirectory = new File(directory, this.server.getUpdateFolder());
        }
        HashMap<String, File> plugins = new HashMap<String, File>();
        HashSet<String> loadedPlugins = new HashSet<String>();
        HashMap<String, LinkedList<String>> dependencies = new HashMap<String, LinkedList<String>>();
        HashMap softDependencies = new HashMap();
        File[] fileArray = directory.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            block30: {
                File file = fileArray[n2];
                PluginLoader loader = null;
                for (Pattern filter : filters) {
                    Matcher match = filter.matcher(file.getName());
                    if (!match.find()) continue;
                    loader = this.fileAssociations.get(filter);
                }
                if (loader != null) {
                    List<String> loadBeforeSet;
                    List<String> dependencySet;
                    List<String> softDependencySet;
                    File replacedFile;
                    PluginDescriptionFile description;
                    block31: {
                        description = null;
                        try {
                            description = loader.getPluginDescription(file);
                            String name = description.getName();
                            if (name.equalsIgnoreCase("bukkit") || name.equalsIgnoreCase("minecraft") || name.equalsIgnoreCase("mojang")) {
                                this.server.getLogger().log(Level.SEVERE, "Could not load '" + file.getPath() + "' in folder '" + directory.getPath() + "': Restricted Name");
                                break block30;
                            }
                            if (description.rawName.indexOf(32) == -1) break block31;
                            this.server.getLogger().warning(String.format("Plugin `%s' uses the space-character (0x20) in its name `%s' - this will not work in Minecraft 1.12", description.getFullName(), description.rawName));
                        }
                        catch (InvalidDescriptionException ex) {
                            this.server.getLogger().log(Level.SEVERE, "Could not load '" + file.getPath() + "' in folder '" + directory.getPath() + "'", ex);
                            break block30;
                        }
                    }
                    if ((replacedFile = plugins.put(description.getName(), file)) != null) {
                        this.server.getLogger().severe(String.format("Ambiguous plugin name `%s' for files `%s' and `%s' in `%s'", description.getName(), file.getPath(), replacedFile.getPath(), directory.getPath()));
                    }
                    if ((softDependencySet = description.getSoftDepend()) != null && !softDependencySet.isEmpty()) {
                        if (softDependencies.containsKey(description.getName())) {
                            ((Collection)softDependencies.get(description.getName())).addAll(softDependencySet);
                        } else {
                            softDependencies.put(description.getName(), new LinkedList<String>(softDependencySet));
                        }
                    }
                    if ((dependencySet = description.getDepend()) != null && !dependencySet.isEmpty()) {
                        dependencies.put(description.getName(), new LinkedList<String>(dependencySet));
                    }
                    if ((loadBeforeSet = description.getLoadBefore()) != null && !loadBeforeSet.isEmpty()) {
                        for (String loadBeforeTarget : loadBeforeSet) {
                            if (softDependencies.containsKey(loadBeforeTarget)) {
                                ((Collection)softDependencies.get(loadBeforeTarget)).add(description.getName());
                                continue;
                            }
                            LinkedList<String> shortSoftDependency = new LinkedList<String>();
                            shortSoftDependency.add(description.getName());
                            softDependencies.put(loadBeforeTarget, shortSoftDependency);
                        }
                    }
                }
            }
            ++n2;
        }
        while (!plugins.isEmpty()) {
            File file;
            boolean missingDependency = true;
            Iterator pluginIterator = plugins.keySet().iterator();
            while (pluginIterator.hasNext()) {
                String plugin = (String)pluginIterator.next();
                if (dependencies.containsKey(plugin)) {
                    Iterator dependencyIterator = ((Collection)dependencies.get(plugin)).iterator();
                    while (dependencyIterator.hasNext()) {
                        String dependency = (String)dependencyIterator.next();
                        if (loadedPlugins.contains(dependency)) {
                            dependencyIterator.remove();
                            continue;
                        }
                        if (plugins.containsKey(dependency)) continue;
                        missingDependency = false;
                        File file2 = (File)plugins.get(plugin);
                        pluginIterator.remove();
                        softDependencies.remove(plugin);
                        dependencies.remove(plugin);
                        this.server.getLogger().log(Level.SEVERE, "Could not load '" + file2.getPath() + "' in folder '" + directory.getPath() + "'", new UnknownDependencyException(dependency));
                        break;
                    }
                    if (dependencies.containsKey(plugin) && ((Collection)dependencies.get(plugin)).isEmpty()) {
                        dependencies.remove(plugin);
                    }
                }
                if (softDependencies.containsKey(plugin)) {
                    Iterator softDependencyIterator = ((Collection)softDependencies.get(plugin)).iterator();
                    while (softDependencyIterator.hasNext()) {
                        String softDependency = (String)softDependencyIterator.next();
                        if (plugins.containsKey(softDependency)) continue;
                        softDependencyIterator.remove();
                    }
                    if (((Collection)softDependencies.get(plugin)).isEmpty()) {
                        softDependencies.remove(plugin);
                    }
                }
                if (dependencies.containsKey(plugin) || softDependencies.containsKey(plugin) || !plugins.containsKey(plugin)) continue;
                file = (File)plugins.get(plugin);
                pluginIterator.remove();
                missingDependency = false;
                try {
                    result.add(this.loadPlugin(file));
                    loadedPlugins.add(plugin);
                }
                catch (InvalidPluginException ex) {
                    this.server.getLogger().log(Level.SEVERE, "Could not load '" + file.getPath() + "' in folder '" + directory.getPath() + "'", ex);
                }
            }
            if (!missingDependency) continue;
            pluginIterator = plugins.keySet().iterator();
            while (pluginIterator.hasNext()) {
                String plugin = (String)pluginIterator.next();
                if (dependencies.containsKey(plugin)) continue;
                softDependencies.remove(plugin);
                missingDependency = false;
                file = (File)plugins.get(plugin);
                pluginIterator.remove();
                try {
                    result.add(this.loadPlugin(file));
                    loadedPlugins.add(plugin);
                    break;
                }
                catch (InvalidPluginException ex) {
                    this.server.getLogger().log(Level.SEVERE, "Could not load '" + file.getPath() + "' in folder '" + directory.getPath() + "'", ex);
                }
            }
            if (!missingDependency) continue;
            softDependencies.clear();
            dependencies.clear();
            Iterator failedPluginIterator = plugins.values().iterator();
            while (failedPluginIterator.hasNext()) {
                file = (File)failedPluginIterator.next();
                failedPluginIterator.remove();
                this.server.getLogger().log(Level.SEVERE, "Could not load '" + file.getPath() + "' in folder '" + directory.getPath() + "': circular dependency detected");
            }
        }
        TimingsCommand.timingStart = System.nanoTime();
        return result.toArray(new Plugin[result.size()]);
    }

    @Override
    public synchronized Plugin loadPlugin(File file) throws InvalidPluginException, UnknownDependencyException {
        Validate.notNull(file, "File cannot be null");
        this.checkUpdate(file);
        Set<Pattern> filters = this.fileAssociations.keySet();
        Plugin result = null;
        for (Pattern filter : filters) {
            String name;
            Matcher match = filter.matcher(name = file.getName());
            if (!match.find()) continue;
            PluginLoader loader = this.fileAssociations.get(filter);
            result = loader.loadPlugin(file);
        }
        if (result != null) {
            this.plugins.add(result);
            this.lookupNames.put(result.getDescription().getName(), result);
        }
        return result;
    }

    private void checkUpdate(File file) {
        if (updateDirectory == null || !updateDirectory.isDirectory()) {
            return;
        }
        File updateFile = new File(updateDirectory, file.getName());
        if (updateFile.isFile() && FileUtil.copy(updateFile, file)) {
            updateFile.delete();
        }
    }

    @Override
    public synchronized Plugin getPlugin(String name) {
        return this.lookupNames.get(name.replace(' ', '_'));
    }

    @Override
    public synchronized Plugin[] getPlugins() {
        return this.plugins.toArray(new Plugin[0]);
    }

    @Override
    public boolean isPluginEnabled(String name) {
        Plugin plugin = this.getPlugin(name);
        return this.isPluginEnabled(plugin);
    }

    @Override
    public boolean isPluginEnabled(Plugin plugin) {
        if (plugin != null && this.plugins.contains(plugin)) {
            return plugin.isEnabled();
        }
        return false;
    }

    @Override
    public void enablePlugin(Plugin plugin) {
        if (!plugin.isEnabled()) {
            List<Command> pluginCommands = PluginCommandYamlParser.parse(plugin);
            if (!pluginCommands.isEmpty()) {
                this.commandMap.registerAll(plugin.getDescription().getName(), pluginCommands);
            }
            try {
                plugin.getPluginLoader().enablePlugin(plugin);
            }
            catch (Throwable ex) {
                this.server.getLogger().log(Level.SEVERE, "Error occurred (in the plugin loader) while enabling " + plugin.getDescription().getFullName() + " (Is it up to date?)", ex);
            }
            HandlerList.bakeAll();
        }
    }

    @Override
    public void disablePlugins() {
        Plugin[] plugins = this.getPlugins();
        int i = plugins.length - 1;
        while (i >= 0) {
            this.disablePlugin(plugins[i]);
            --i;
        }
    }

    @Override
    public void disablePlugin(Plugin plugin) {
        if (plugin.isEnabled()) {
            try {
                plugin.getPluginLoader().disablePlugin(plugin);
            }
            catch (Throwable ex) {
                this.server.getLogger().log(Level.SEVERE, "Error occurred (in the plugin loader) while disabling " + plugin.getDescription().getFullName() + " (Is it up to date?)", ex);
            }
            try {
                this.server.getScheduler().cancelTasks(plugin);
            }
            catch (Throwable ex) {
                this.server.getLogger().log(Level.SEVERE, "Error occurred (in the plugin loader) while cancelling tasks for " + plugin.getDescription().getFullName() + " (Is it up to date?)", ex);
            }
            try {
                this.server.getServicesManager().unregisterAll(plugin);
            }
            catch (Throwable ex) {
                this.server.getLogger().log(Level.SEVERE, "Error occurred (in the plugin loader) while unregistering services for " + plugin.getDescription().getFullName() + " (Is it up to date?)", ex);
            }
            try {
                HandlerList.unregisterAll(plugin);
            }
            catch (Throwable ex) {
                this.server.getLogger().log(Level.SEVERE, "Error occurred (in the plugin loader) while unregistering events for " + plugin.getDescription().getFullName() + " (Is it up to date?)", ex);
            }
            try {
                this.server.getMessenger().unregisterIncomingPluginChannel(plugin);
                this.server.getMessenger().unregisterOutgoingPluginChannel(plugin);
            }
            catch (Throwable ex) {
                this.server.getLogger().log(Level.SEVERE, "Error occurred (in the plugin loader) while unregistering plugin channels for " + plugin.getDescription().getFullName() + " (Is it up to date?)", ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearPlugins() {
        SimplePluginManager simplePluginManager = this;
        synchronized (simplePluginManager) {
            this.disablePlugins();
            this.plugins.clear();
            this.lookupNames.clear();
            HandlerList.unregisterAll();
            this.fileAssociations.clear();
            this.permissions.clear();
            this.defaultPerms.get(true).clear();
            this.defaultPerms.get(false).clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void callEvent(Event event) {
        if (event.isAsynchronous()) {
            if (Thread.holdsLock(this)) {
                throw new IllegalStateException(String.valueOf(event.getEventName()) + " cannot be triggered asynchronously from inside synchronized code.");
            }
            if (this.server.isPrimaryThread()) {
                throw new IllegalStateException(String.valueOf(event.getEventName()) + " cannot be triggered asynchronously from primary server thread.");
            }
            this.fireEvent(event);
        } else {
            SimplePluginManager simplePluginManager = this;
            synchronized (simplePluginManager) {
                this.fireEvent(event);
            }
        }
    }

    private void fireEvent(Event event) {
        RegisteredListener[] listeners;
        HandlerList handlers = event.getHandlers();
        RegisteredListener[] registeredListenerArray = listeners = handlers.getRegisteredListeners();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            RegisteredListener registration = registeredListenerArray[n2];
            if (registration.getPlugin().isEnabled()) {
                try {
                    registration.callEvent(event);
                }
                catch (AuthorNagException ex) {
                    Plugin plugin = registration.getPlugin();
                    if (plugin.isNaggable()) {
                        plugin.setNaggable(false);
                        this.server.getLogger().log(Level.SEVERE, String.format("Nag author(s): '%s' of '%s' about the following: %s", plugin.getDescription().getAuthors(), plugin.getDescription().getFullName(), ex.getMessage()));
                    }
                }
                catch (Throwable ex) {
                    this.server.getLogger().log(Level.SEVERE, "Could not pass event " + event.getEventName() + " to " + registration.getPlugin().getDescription().getFullName(), ex);
                }
            }
            ++n2;
        }
    }

    @Override
    public void registerEvents(Listener listener, Plugin plugin) {
        if (!plugin.isEnabled()) {
            throw new IllegalPluginAccessException("Plugin attempted to register " + listener + " while not enabled");
        }
        for (Map.Entry<Class<? extends Event>, Set<RegisteredListener>> entry : plugin.getPluginLoader().createRegisteredListeners(listener, plugin).entrySet()) {
            this.getEventListeners(this.getRegistrationClass(entry.getKey())).registerAll((Collection<RegisteredListener>)entry.getValue());
        }
    }

    @Override
    public void registerEvent(Class<? extends Event> event, Listener listener, EventPriority priority, EventExecutor executor, Plugin plugin) {
        this.registerEvent(event, listener, priority, executor, plugin, false);
    }

    @Override
    public void registerEvent(Class<? extends Event> event, Listener listener, EventPriority priority, EventExecutor executor, Plugin plugin, boolean ignoreCancelled) {
        Validate.notNull(listener, "Listener cannot be null");
        Validate.notNull((Object)priority, "Priority cannot be null");
        Validate.notNull(executor, "Executor cannot be null");
        Validate.notNull(plugin, "Plugin cannot be null");
        if (!plugin.isEnabled()) {
            throw new IllegalPluginAccessException("Plugin attempted to register " + event + " while not enabled");
        }
        if (this.useTimings) {
            this.getEventListeners(event).register(new TimedRegisteredListener(listener, executor, priority, plugin, ignoreCancelled));
        } else {
            this.getEventListeners(event).register(new RegisteredListener(listener, executor, priority, plugin, ignoreCancelled));
        }
    }

    private HandlerList getEventListeners(Class<? extends Event> type) {
        try {
            Method method = this.getRegistrationClass(type).getDeclaredMethod("getHandlerList", new Class[0]);
            method.setAccessible(true);
            return (HandlerList)method.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalPluginAccessException(e.toString());
        }
    }

    private Class<? extends Event> getRegistrationClass(Class<? extends Event> clazz) {
        try {
            clazz.getDeclaredMethod("getHandlerList", new Class[0]);
            return clazz;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            if (clazz.getSuperclass() != null && !clazz.getSuperclass().equals(Event.class) && Event.class.isAssignableFrom(clazz.getSuperclass())) {
                return this.getRegistrationClass(clazz.getSuperclass().asSubclass(Event.class));
            }
            throw new IllegalPluginAccessException("Unable to find handler list for event " + clazz.getName() + ". Static getHandlerList method required!");
        }
    }

    @Override
    public Permission getPermission(String name) {
        return this.permissions.get(name.toLowerCase(Locale.ENGLISH));
    }

    @Override
    public void addPermission(Permission perm) {
        String name = perm.getName().toLowerCase(Locale.ENGLISH);
        if (this.permissions.containsKey(name)) {
            throw new IllegalArgumentException("The permission " + name + " is already defined!");
        }
        this.permissions.put(name, perm);
        this.calculatePermissionDefault(perm);
    }

    @Override
    public Set<Permission> getDefaultPermissions(boolean op) {
        return ImmutableSet.copyOf((Collection)this.defaultPerms.get(op));
    }

    @Override
    public void removePermission(Permission perm) {
        this.removePermission(perm.getName());
    }

    @Override
    public void removePermission(String name) {
        this.permissions.remove(name.toLowerCase(Locale.ENGLISH));
    }

    @Override
    public void recalculatePermissionDefaults(Permission perm) {
        if (perm != null && this.permissions.containsKey(perm.getName().toLowerCase(Locale.ENGLISH))) {
            this.defaultPerms.get(true).remove(perm);
            this.defaultPerms.get(false).remove(perm);
            this.calculatePermissionDefault(perm);
        }
    }

    private void calculatePermissionDefault(Permission perm) {
        if (perm.getDefault() == PermissionDefault.OP || perm.getDefault() == PermissionDefault.TRUE) {
            this.defaultPerms.get(true).add(perm);
            this.dirtyPermissibles(true);
        }
        if (perm.getDefault() == PermissionDefault.NOT_OP || perm.getDefault() == PermissionDefault.TRUE) {
            this.defaultPerms.get(false).add(perm);
            this.dirtyPermissibles(false);
        }
    }

    private void dirtyPermissibles(boolean op) {
        Set<Permissible> permissibles = this.getDefaultPermSubscriptions(op);
        for (Permissible p : permissibles) {
            p.recalculatePermissions();
        }
    }

    @Override
    public void subscribeToPermission(String permission, Permissible permissible) {
        String name = permission.toLowerCase(Locale.ENGLISH);
        Map<Permissible, Boolean> map = this.permSubs.get(name);
        if (map == null) {
            map = new WeakHashMap<Permissible, Boolean>();
            this.permSubs.put(name, map);
        }
        map.put(permissible, true);
    }

    @Override
    public void unsubscribeFromPermission(String permission, Permissible permissible) {
        String name = permission.toLowerCase(Locale.ENGLISH);
        Map<Permissible, Boolean> map = this.permSubs.get(name);
        if (map != null) {
            map.remove(permissible);
            if (map.isEmpty()) {
                this.permSubs.remove(name);
            }
        }
    }

    @Override
    public Set<Permissible> getPermissionSubscriptions(String permission) {
        String name = permission.toLowerCase(Locale.ENGLISH);
        Map<Permissible, Boolean> map = this.permSubs.get(name);
        if (map == null) {
            return ImmutableSet.of();
        }
        return ImmutableSet.copyOf(map.keySet());
    }

    @Override
    public void subscribeToDefaultPerms(boolean op, Permissible permissible) {
        Map<Permissible, Boolean> map = this.defSubs.get(op);
        if (map == null) {
            map = new WeakHashMap<Permissible, Boolean>();
            this.defSubs.put(op, map);
        }
        map.put(permissible, true);
    }

    @Override
    public void unsubscribeFromDefaultPerms(boolean op, Permissible permissible) {
        Map<Permissible, Boolean> map = this.defSubs.get(op);
        if (map != null) {
            map.remove(permissible);
            if (map.isEmpty()) {
                this.defSubs.remove(op);
            }
        }
    }

    @Override
    public Set<Permissible> getDefaultPermSubscriptions(boolean op) {
        Map<Permissible, Boolean> map = this.defSubs.get(op);
        if (map == null) {
            return ImmutableSet.of();
        }
        return ImmutableSet.copyOf(map.keySet());
    }

    @Override
    public Set<Permission> getPermissions() {
        return new HashSet<Permission>(this.permissions.values());
    }

    @Override
    public boolean useTimings() {
        return this.useTimings;
    }

    public void useTimings(boolean use) {
        this.useTimings = use;
    }
}

