/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.loot;

import org.apache.commons.lang.Validate;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;

public final class LootContext {
    public static final int DEFAULT_LOOT_MODIFIER = -1;
    private final Location location;
    private final float luck;
    private final int lootingModifier;
    private final Entity lootedEntity;
    private final HumanEntity killer;

    private LootContext(Location location, float luck, int lootingModifier, Entity lootedEntity, HumanEntity killer) {
        Validate.notNull(location, "LootContext location cannot be null");
        Validate.notNull(location.getWorld(), "LootContext World cannot be null");
        this.location = location;
        this.luck = luck;
        this.lootingModifier = lootingModifier;
        this.lootedEntity = lootedEntity;
        this.killer = killer;
    }

    public Location getLocation() {
        return this.location;
    }

    public float getLuck() {
        return this.luck;
    }

    public int getLootingModifier() {
        return this.lootingModifier;
    }

    public Entity getLootedEntity() {
        return this.lootedEntity;
    }

    public HumanEntity getKiller() {
        return this.killer;
    }

    /* synthetic */ LootContext(Location location, float f, int n, Entity entity, HumanEntity humanEntity, LootContext lootContext) {
        this(location, f, n, entity, humanEntity);
    }

    public static class Builder {
        private final Location location;
        private float luck;
        private int lootingModifier = -1;
        private Entity lootedEntity;
        private HumanEntity killer;

        public Builder(Location location) {
            this.location = location;
        }

        public Builder luck(float luck) {
            this.luck = luck;
            return this;
        }

        public Builder lootingModifier(int modifier) {
            this.lootingModifier = modifier;
            return this;
        }

        public Builder lootedEntity(Entity lootedEntity) {
            this.lootedEntity = lootedEntity;
            return this;
        }

        public Builder killer(HumanEntity killer) {
            this.killer = killer;
            return this;
        }

        public LootContext build() {
            return new LootContext(this.location, this.luck, this.lootingModifier, this.lootedEntity, this.killer, null);
        }
    }
}

