/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.entity.memory;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MemoryKey<T>
implements Keyed {
    private final NamespacedKey namespacedKey;
    private final Class<T> tClass;
    private static final Map<NamespacedKey, MemoryKey> MEMORY_KEYS = new HashMap<NamespacedKey, MemoryKey>();
    public static final MemoryKey<Location> HOME = new MemoryKey<Location>(NamespacedKey.minecraft("home"), Location.class);
    public static final MemoryKey<Location> MEETING_POINT = new MemoryKey<Location>(NamespacedKey.minecraft("meeting_point"), Location.class);
    public static final MemoryKey<Location> JOB_SITE = new MemoryKey<Location>(NamespacedKey.minecraft("job_site"), Location.class);

    private MemoryKey(NamespacedKey namespacedKey, Class<T> tClass) {
        this.namespacedKey = namespacedKey;
        this.tClass = tClass;
        MEMORY_KEYS.put(namespacedKey, this);
    }

    @Override
    @NotNull
    public NamespacedKey getKey() {
        return this.namespacedKey;
    }

    @NotNull
    public Class<T> getMemoryClass() {
        return this.tClass;
    }

    @Nullable
    public static MemoryKey getByKey(@NotNull NamespacedKey namespacedKey) {
        return MEMORY_KEYS.get(namespacedKey);
    }

    @NotNull
    public static Set<MemoryKey> values() {
        return new HashSet<MemoryKey>(MEMORY_KEYS.values());
    }
}

