/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.generator;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.generator.BlockPopulator;
import org.bukkit.material.MaterialData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ChunkGenerator {
    @NotNull
    public ChunkData generateChunkData(@NotNull World world, @NotNull Random random, int x, int z, @NotNull BiomeGrid biome) {
        throw new UnsupportedOperationException("Custom generator is missing required method generateChunkData");
    }

    @NotNull
    protected final ChunkData createChunkData(@NotNull World world) {
        return Bukkit.getServer().createChunkData(world);
    }

    public boolean canSpawn(@NotNull World world, int x, int z) {
        Block highest = world.getBlockAt(x, world.getHighestBlockYAt(x, z), z);
        switch (world.getEnvironment()) {
            case NETHER: {
                return true;
            }
            case THE_END: {
                return highest.getType() != Material.AIR && highest.getType() != Material.WATER && highest.getType() != Material.LAVA;
            }
        }
        return highest.getType() == Material.SAND || highest.getType() == Material.GRAVEL;
    }

    @NotNull
    public List<BlockPopulator> getDefaultPopulators(@NotNull World world) {
        return new ArrayList<BlockPopulator>();
    }

    @Nullable
    public Location getFixedSpawnLocation(@NotNull World world, @NotNull Random random) {
        return null;
    }

    public boolean isParallelCapable() {
        return false;
    }

    public boolean shouldGenerateCaves() {
        return false;
    }

    public boolean shouldGenerateDecorations() {
        return false;
    }

    public boolean shouldGenerateMobs() {
        return false;
    }

    public boolean shouldGenerateStructures() {
        return false;
    }

    public static interface BiomeGrid {
        @Deprecated
        @NotNull
        public Biome getBiome(int var1, int var2);

        @NotNull
        public Biome getBiome(int var1, int var2, int var3);

        @Deprecated
        public void setBiome(int var1, int var2, @NotNull Biome var3);

        public void setBiome(int var1, int var2, int var3, @NotNull Biome var4);
    }

    public static interface ChunkData {
        public int getMaxHeight();

        public void setBlock(int var1, int var2, int var3, @NotNull Material var4);

        public void setBlock(int var1, int var2, int var3, @NotNull MaterialData var4);

        public void setBlock(int var1, int var2, int var3, @NotNull BlockData var4);

        public void setRegion(int var1, int var2, int var3, int var4, int var5, int var6, @NotNull Material var7);

        public void setRegion(int var1, int var2, int var3, int var4, int var5, int var6, @NotNull MaterialData var7);

        public void setRegion(int var1, int var2, int var3, int var4, int var5, int var6, @NotNull BlockData var7);

        @NotNull
        public Material getType(int var1, int var2, int var3);

        @NotNull
        public MaterialData getTypeAndData(int var1, int var2, int var3);

        @NotNull
        public BlockData getBlockData(int var1, int var2, int var3);

        @Deprecated
        public byte getData(int var1, int var2, int var3);
    }
}

