/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.command.defaults;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.defaults.BukkitCommand;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.jetbrains.annotations.NotNull;

public class PluginsCommand
extends BukkitCommand {
    public PluginsCommand(@NotNull String name) {
        super(name);
        this.description = "Gets a list of plugins running on the server";
        this.usageMessage = "/plugins";
        this.setPermission("bukkit.command.plugins");
        this.setAliases(Arrays.asList("pl"));
    }

    @Override
    public boolean execute(@NotNull CommandSender sender, @NotNull String currentAlias, @NotNull String[] args) {
        if (!this.testPermission(sender)) {
            return true;
        }
        if (sender instanceof Player && sender.hasPermission("bukkit.command.version")) {
            sender.spigot().sendMessage(this.getPluginListSpigot());
        } else {
            sender.sendMessage("Plugins " + this.getPluginList());
        }
        return true;
    }

    @Override
    @NotNull
    public List<String> tabComplete(@NotNull CommandSender sender, @NotNull String alias, @NotNull String[] args) throws IllegalArgumentException {
        return Collections.emptyList();
    }

    @NotNull
    private String getPluginList() {
        Plugin[] plugins;
        StringBuilder pluginList = new StringBuilder();
        Plugin[] pluginArray = plugins = Bukkit.getPluginManager().getPlugins();
        int n = plugins.length;
        int n2 = 0;
        while (n2 < n) {
            Plugin plugin = pluginArray[n2];
            if (pluginList.length() > 0) {
                pluginList.append((Object)ChatColor.WHITE);
                pluginList.append(", ");
            }
            pluginList.append((Object)(plugin.isEnabled() ? ChatColor.GREEN : ChatColor.RED));
            pluginList.append(plugin.getDescription().getName());
            if (plugin.getDescription().getProvides().size() > 0) {
                pluginList.append(" (").append(String.join((CharSequence)", ", plugin.getDescription().getProvides())).append(")");
            }
            ++n2;
        }
        return "(" + plugins.length + "): " + pluginList.toString();
    }

    @NotNull
    private BaseComponent[] getPluginListSpigot() {
        Plugin[] plugins = Bukkit.getPluginManager().getPlugins();
        ComponentBuilder pluginList = new ComponentBuilder("Plugins (" + plugins.length + "): ");
        int index = 0;
        Plugin[] pluginArray = plugins;
        int n = plugins.length;
        int n2 = 0;
        while (n2 < n) {
            Plugin plugin = pluginArray[n2];
            if (index++ > 0) {
                pluginList.append(", ", ComponentBuilder.FormatRetention.NONE).color(net.md_5.bungee.api.ChatColor.WHITE);
            }
            PluginDescriptionFile description = plugin.getDescription();
            ComponentBuilder hoverEventComponents = new ComponentBuilder();
            hoverEventComponents.append("Version: ").color(net.md_5.bungee.api.ChatColor.WHITE).append(description.getVersion()).color(net.md_5.bungee.api.ChatColor.GREEN);
            if (description.getDescription() != null) {
                hoverEventComponents.append("\nDescription: ").color(net.md_5.bungee.api.ChatColor.WHITE).append(description.getDescription()).color(net.md_5.bungee.api.ChatColor.GREEN);
            }
            if (description.getWebsite() != null) {
                hoverEventComponents.append("\nWebsite: ").color(net.md_5.bungee.api.ChatColor.WHITE).append(description.getWebsite()).color(net.md_5.bungee.api.ChatColor.GREEN);
            }
            if (!description.getAuthors().isEmpty()) {
                if (description.getAuthors().size() == 1) {
                    hoverEventComponents.append("\nAuthor: ");
                } else {
                    hoverEventComponents.append("\nAuthors: ");
                }
                hoverEventComponents.color(net.md_5.bungee.api.ChatColor.WHITE).append(this.getAuthors(description));
            }
            HoverEvent hoverEvent = new HoverEvent(HoverEvent.Action.SHOW_TEXT, hoverEventComponents.create());
            ClickEvent clickEvent = new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/version " + description.getName());
            pluginList.append(plugin.getDescription().getName());
            pluginList.color(plugin.isEnabled() ? net.md_5.bungee.api.ChatColor.GREEN : net.md_5.bungee.api.ChatColor.RED);
            pluginList.event(hoverEvent).event(clickEvent);
            if (plugin.getDescription().getProvides().size() > 0) {
                pluginList.append("( ", ComponentBuilder.FormatRetention.NONE).color(net.md_5.bungee.api.ChatColor.WHITE).append(String.join((CharSequence)", ", plugin.getDescription().getProvides())).append(")");
            }
            ++n2;
        }
        return pluginList.create();
    }

    @NotNull
    private BaseComponent[] getAuthors(@NotNull PluginDescriptionFile description) {
        ComponentBuilder result = new ComponentBuilder();
        List<String> authors = description.getAuthors();
        int i = 0;
        while (i < authors.size()) {
            if (i > 0) {
                result.append(i < authors.size() - 1 ? ", " : " and ", ComponentBuilder.FormatRetention.NONE);
                result.color(net.md_5.bungee.api.ChatColor.WHITE);
            }
            result.append(authors.get(i)).color(net.md_5.bungee.api.ChatColor.GREEN);
            ++i;
        }
        return result.create();
    }
}

