package org.bukkit;

/**
 * Tree and organic structure types.
 */
public enum TreeType {

    /**
     * Regular tree, no branches
     */
    TREE,
    /**
     * Regular tree, extra tall with branches
     */
    BIG_TREE,
    /**
     * Redwood tree, shaped like a pine tree
     */
    REDWOOD,
    /**
     * Tall redwood tree with just a few leaves at the top
     */
    TALL_REDWOOD,
    /**
     * Birch tree
     */
    BIRCH,
    /**
     * Standard jungle tree; 4 blocks wide and tall
     */
    JUNGLE,
    /**
     * Smaller jungle tree; 1 block wide
     */
    SMALL_JUNGLE,
    /**
     * Small bush that grows in the jungle
     */
    JUNGLE_BUSH,
    /**
     * Big red mushroom; short and fat
     */
    RED_MUSHROOM,
    /**
     * Big brown mushroom; tall and umbrella-like
     */
    BROWN_MUSHROOM,
    /**
     * Swamp tree (regular with vines on the side)
     */
    SWAMP,
}
