/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.ldap.expression;

import com.avaje.ebean.ExampleExpression;
import com.avaje.ebean.Expression;
import com.avaje.ebean.ExpressionFactory;
import com.avaje.ebean.ExpressionList;
import com.avaje.ebean.Junction;
import com.avaje.ebean.LikeType;
import com.avaje.ebean.Query;
import com.avaje.ebeaninternal.server.ldap.LdapPersistenceException;
import com.avaje.ebeaninternal.server.ldap.expression.LdJunctionExpression;
import com.avaje.ebeaninternal.server.ldap.expression.LdLikeExpression;
import com.avaje.ebeaninternal.server.ldap.expression.LdLogicExpression;
import com.avaje.ebeaninternal.server.ldap.expression.LdNotExpression;
import com.avaje.ebeaninternal.server.ldap.expression.LdPresentExpression;
import com.avaje.ebeaninternal.server.ldap.expression.LdRawExpression;
import com.avaje.ebeaninternal.server.ldap.expression.LdSimpleExpression;
import java.util.Collection;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LdapExpressionFactory
implements ExpressionFactory {
    @Override
    public String getLang() {
        return "ldap";
    }

    public ExpressionFactory createExpressionFactory(String path) {
        return new LdapExpressionFactory();
    }

    @Override
    public Expression allEq(Map<String, Object> propertyMap) {
        LdJunctionExpression.Conjunction conjunction = new LdJunctionExpression.Conjunction(this);
        for (Map.Entry<String, Object> entry : propertyMap.entrySet()) {
            conjunction.add(this.eq(entry.getKey(), entry.getValue()));
        }
        return conjunction;
    }

    @Override
    public Expression and(Expression expOne, Expression expTwo) {
        return new LdLogicExpression.And(expOne, expTwo);
    }

    @Override
    public Expression between(String propertyName, Object value1, Object value2) {
        Expression e1 = this.gt(propertyName, value1);
        Expression e2 = this.lt(propertyName, value2);
        return this.and(e1, e2);
    }

    @Override
    public Expression betweenProperties(String lowProperty, String highProperty, Object value) {
        throw new RuntimeException("Not Implemented");
    }

    @Override
    public Expression contains(String propertyName, String value) {
        if (!value.endsWith("*")) {
            value = "*" + value + "*";
        }
        return new LdSimpleExpression(propertyName, LdSimpleExpression.Op.EQ, value);
    }

    @Override
    public <T> Junction<T> conjunction(Query<T> query) {
        return new LdJunctionExpression.Conjunction<T>(query, query.where());
    }

    @Override
    public <T> Junction<T> disjunction(Query<T> query) {
        return new LdJunctionExpression.Disjunction<T>(query, query.where());
    }

    @Override
    public <T> Junction<T> conjunction(Query<T> query, ExpressionList<T> parent) {
        return new LdJunctionExpression.Conjunction<T>(query, parent);
    }

    @Override
    public <T> Junction<T> disjunction(Query<T> query, ExpressionList<T> parent) {
        return new LdJunctionExpression.Disjunction<T>(query, parent);
    }

    @Override
    public Expression endsWith(String propertyName, String value) {
        if (!value.startsWith("*")) {
            value = "*" + value;
        }
        return new LdLikeExpression(propertyName, value);
    }

    @Override
    public Expression eq(String propertyName, Object value) {
        return new LdSimpleExpression(propertyName, LdSimpleExpression.Op.EQ, value);
    }

    public Expression lucene(String propertyName, String value) {
        throw new RuntimeException("Not Implemented");
    }

    public Expression lucene(String value) {
        throw new RuntimeException("Not Implemented");
    }

    @Override
    public ExampleExpression exampleLike(Object example, boolean caseInsensitive, LikeType likeType) {
        throw new RuntimeException("Not Implemented");
    }

    @Override
    public ExampleExpression exampleLike(Object example) {
        throw new RuntimeException("Not Implemented");
    }

    @Override
    public Expression ge(String propertyName, Object value) {
        return new LdSimpleExpression(propertyName, LdSimpleExpression.Op.GT_EQ, value);
    }

    @Override
    public Expression gt(String propertyName, Object value) {
        return new LdSimpleExpression(propertyName, LdSimpleExpression.Op.GT, value);
    }

    @Override
    public Expression icontains(String propertyName, String value) {
        if (!value.endsWith("*")) {
            value = "*" + value + "*";
        }
        return new LdLikeExpression(propertyName, value);
    }

    @Override
    public Expression idEq(Object value) {
        return null;
    }

    @Override
    public Expression idIn(List<?> idList) {
        throw new RuntimeException("Not Implemented");
    }

    @Override
    public Expression iendsWith(String propertyName, String value) {
        if (!value.startsWith("*")) {
            value = "*" + value;
        }
        return new LdLikeExpression(propertyName, value);
    }

    @Override
    public Expression ieq(String propertyName, String value) {
        return new LdSimpleExpression(propertyName, LdSimpleExpression.Op.EQ, value);
    }

    @Override
    public ExampleExpression iexampleLike(Object example) {
        throw new RuntimeException("Not Implemented");
    }

    @Override
    public Expression ilike(String propertyName, String value) {
        return new LdLikeExpression(propertyName, value);
    }

    @Override
    public Expression in(String propertyName, Collection<?> values) {
        if (values == null || values.isEmpty()) {
            throw new LdapPersistenceException("collection can't be empty for Ldap");
        }
        LdJunctionExpression.Disjunction disjunction = new LdJunctionExpression.Disjunction(this);
        for (Object v : values) {
            disjunction.add(this.eq(propertyName, v));
        }
        return disjunction;
    }

    @Override
    public Expression in(String propertyName, Object[] values) {
        if (values == null || values.length == 0) {
            throw new LdapPersistenceException("values can't be empty for Ldap");
        }
        LdJunctionExpression.Disjunction disjunction = new LdJunctionExpression.Disjunction(this);
        for (Object v : values) {
            disjunction.add(this.eq(propertyName, v));
        }
        return disjunction;
    }

    @Override
    public Expression in(String propertyName, Query<?> subQuery) {
        throw new RuntimeException("Not Implemented");
    }

    @Override
    public Expression isNotNull(String propertyName) {
        return new LdPresentExpression(propertyName);
    }

    @Override
    public Expression isNull(String propertyName) {
        LdPresentExpression exp = new LdPresentExpression(propertyName);
        return new LdNotExpression(exp);
    }

    @Override
    public Expression istartsWith(String propertyName, String value) {
        if (!value.endsWith("*")) {
            value = value + "*";
        }
        return new LdLikeExpression(propertyName, value);
    }

    @Override
    public Expression le(String propertyName, Object value) {
        return new LdSimpleExpression(propertyName, LdSimpleExpression.Op.LT_EQ, value);
    }

    @Override
    public Expression like(String propertyName, String value) {
        return new LdLikeExpression(propertyName, value);
    }

    @Override
    public Expression lt(String propertyName, Object value) {
        return new LdSimpleExpression(propertyName, LdSimpleExpression.Op.LT, value);
    }

    @Override
    public Expression ne(String propertyName, Object value) {
        return new LdSimpleExpression(propertyName, LdSimpleExpression.Op.NOT_EQ, value);
    }

    @Override
    public Expression not(Expression exp) {
        return new LdNotExpression(exp);
    }

    @Override
    public Expression or(Expression expOne, Expression expTwo) {
        return new LdLogicExpression.Or(expOne, expTwo);
    }

    @Override
    public Expression raw(String raw, Object value) {
        if (value != null) {
            return new LdRawExpression(raw, new Object[]{value});
        }
        return new LdRawExpression(raw, null);
    }

    @Override
    public Expression raw(String raw, Object[] values) {
        return new LdRawExpression(raw, values);
    }

    @Override
    public Expression raw(String raw) {
        return new LdRawExpression(raw, null);
    }

    @Override
    public Expression startsWith(String propertyName, String value) {
        if (!value.endsWith("*")) {
            value = value + "*";
        }
        return new LdLikeExpression(propertyName, value);
    }
}

