/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.command.defaults;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.defaults.VanillaCommand;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.StringUtil;

@Deprecated
public class EffectCommand
extends VanillaCommand {
    private static final List<String> effects;

    static {
        ImmutableList.Builder builder = ImmutableList.builder();
        PotionEffectType[] potionEffectTypeArray = PotionEffectType.values();
        int n = potionEffectTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            PotionEffectType type = potionEffectTypeArray[n2];
            if (type != null) {
                builder.add(type.getName());
            }
            ++n2;
        }
        effects = builder.build();
    }

    public EffectCommand() {
        super("effect");
        this.description = "Adds/Removes effects on players";
        this.usageMessage = "/effect <player> <effect|clear> [seconds] [amplifier]";
        this.setPermission("bukkit.command.effect");
    }

    @Override
    public boolean execute(CommandSender sender, String commandLabel, String[] args) {
        if (!this.testPermission(sender)) {
            return true;
        }
        if (args.length < 2) {
            sender.sendMessage(this.getUsage());
            return true;
        }
        Player player = sender.getServer().getPlayer(args[0]);
        if (player == null) {
            sender.sendMessage((Object)((Object)ChatColor.RED) + String.format("Player, %s, not found", args[0]));
            return true;
        }
        if ("clear".equalsIgnoreCase(args[1])) {
            for (PotionEffect effect : player.getActivePotionEffects()) {
                player.removePotionEffect(effect.getType());
            }
            sender.sendMessage(String.format("Took all effects from %s", args[0]));
            return true;
        }
        PotionEffectType effect = PotionEffectType.getByName(args[1]);
        if (effect == null) {
            effect = PotionEffectType.getById(this.getInteger(sender, args[1], 0));
        }
        if (effect == null) {
            sender.sendMessage((Object)((Object)ChatColor.RED) + String.format("Effect, %s, not found", args[1]));
            return true;
        }
        int duration = 600;
        int duration_temp = 30;
        int amplification = 0;
        if (args.length >= 3) {
            duration_temp = this.getInteger(sender, args[2], 0, 1000000);
            duration = effect.isInstant() ? duration_temp : duration_temp * 20;
        } else if (effect.isInstant()) {
            duration = 1;
        }
        if (args.length >= 4) {
            amplification = this.getInteger(sender, args[3], 0, 255);
        }
        if (duration_temp == 0) {
            if (!player.hasPotionEffect(effect)) {
                sender.sendMessage(String.format("Couldn't take %s from %s as they do not have the effect", effect.getName(), args[0]));
                return true;
            }
            player.removePotionEffect(effect);
            EffectCommand.broadcastCommandMessage(sender, String.format("Took %s from %s", effect.getName(), args[0]));
        } else {
            PotionEffect applyEffect = new PotionEffect(effect, duration, amplification);
            player.addPotionEffect(applyEffect, true);
            EffectCommand.broadcastCommandMessage(sender, String.format("Given %s (ID %d) * %d to %s for %d seconds", effect.getName(), effect.getId(), amplification, args[0], duration_temp));
        }
        return true;
    }

    @Override
    public List<String> tabComplete(CommandSender sender, String commandLabel, String[] args) {
        if (args.length == 1) {
            return super.tabComplete(sender, commandLabel, args);
        }
        if (args.length == 2) {
            return StringUtil.copyPartialMatches(args[1], effects, new ArrayList(effects.size()));
        }
        return ImmutableList.of();
    }
}

