/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee;

import com.google.common.base.Joiner;
import java.net.InetSocketAddress;
import java.util.UUID;

public class Util {
    private static final int DEFAULT_PORT = 25565;

    public static InetSocketAddress getAddr(String hostline) {
        String[] split = hostline.split(":");
        int port = 25565;
        if (split.length > 1) {
            port = Integer.parseInt(split[1]);
        }
        return new InetSocketAddress(split[0], port);
    }

    public static String hex(int i) {
        return String.format("0x%02X", i);
    }

    public static String exception(Throwable t) {
        StackTraceElement[] trace = t.getStackTrace();
        return t.getClass().getSimpleName() + " : " + t.getMessage() + (trace.length > 0 ? " @ " + t.getStackTrace()[0].getClassName() + ":" + t.getStackTrace()[0].getLineNumber() : "");
    }

    public static String csv(Iterable<?> objects) {
        return Util.format(objects, ", ");
    }

    public static String format(Iterable<?> objects, String separators) {
        return Joiner.on((String)separators).join(objects);
    }

    public static UUID getUUID(String uuid) {
        return UUID.fromString(uuid.substring(0, 8) + "-" + uuid.substring(8, 12) + "-" + uuid.substring(12, 16) + "-" + uuid.substring(16, 20) + "-" + uuid.substring(20, 32));
    }
}

